using System;
using System.Drawing;
using System.Windows.Forms;


namespace Core
{
	/// <summary>
	/// dWinlock core example program
	/// </summary>


	public class WinForm : System.Windows.Forms.Form
	{
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.TextBox textBox1;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Button bInstallGina;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Panel panel2;
		private int DISABLE = 1;
		private readonly string NL = Environment.NewLine;

		public WinForm()
		{
			InitializeComponent();
		}

		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region code created by Windows form designer
		private void InitializeComponent()
		{
			this.panel1 = new System.Windows.Forms.Panel();
			this.label1 = new System.Windows.Forms.Label();
			this.bInstallGina = new System.Windows.Forms.Button();
			this.panel2 = new System.Windows.Forms.Panel();
			this.textBox1 = new System.Windows.Forms.TextBox();
			this.panel1.SuspendLayout();
			this.panel2.SuspendLayout();
			this.SuspendLayout();
			// 
			// panel1
			// 
			this.panel1.Controls.Add(this.label1);
			this.panel1.Controls.Add(this.bInstallGina);
			this.panel1.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.panel1.Location = new System.Drawing.Point(0, 286);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(432, 48);
			this.panel1.TabIndex = 1;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(120, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(272, 23);
			this.label1.TabIndex = 1;
			this.label1.Text = "needed to disable Ctrl+Alt+Del under Win NT, 2k, XP";
			// 
			// bInstallGina
			// 
			this.bInstallGina.Location = new System.Drawing.Point(8, 13);
			this.bInstallGina.Name = "bInstallGina";
			this.bInstallGina.Size = new System.Drawing.Size(96, 23);
			this.bInstallGina.TabIndex = 0;
			this.bInstallGina.Text = "Install dwlgina";
			this.bInstallGina.Click += new System.EventHandler(this.bInstallGina_Click);
			// 
			// panel2
			// 
			this.panel2.Controls.Add(this.textBox1);
			this.panel2.Dock = System.Windows.Forms.DockStyle.Fill;
			this.panel2.Location = new System.Drawing.Point(0, 0);
			this.panel2.Name = "panel2";
			this.panel2.Size = new System.Drawing.Size(432, 286);
			this.panel2.TabIndex = 2;
			// 
			// textBox1
			// 
			this.textBox1.Dock = System.Windows.Forms.DockStyle.Fill;
			this.textBox1.Location = new System.Drawing.Point(0, 0);
			this.textBox1.Multiline = true;
			this.textBox1.Name = "textBox1";
			this.textBox1.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.textBox1.Size = new System.Drawing.Size(432, 286);
			this.textBox1.TabIndex = 1;
			this.textBox1.Text = "";
			this.textBox1.WordWrap = false;
			// 
			// WinForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(432, 334);
			this.Controls.Add(this.panel2);
			this.Controls.Add(this.panel1);
			this.Name = "WinForm";
			this.Text = "dWinlock core example";
			this.Load += new System.EventHandler(this.WinForm_Load);
			this.panel1.ResumeLayout(false);
			this.panel2.ResumeLayout(false);
			this.ResumeLayout(false);
		}
		#endregion

    private void AddInfo(string info)
    {
      textBox1.AppendText(info + NL);
    }

    private void DisableKeys(int disable)
    {
      dwl.wlDisableItem(dwl.wlShutdown, disable);          // disables shutdown and reboot
      dwl.wlDisableItem(dwl.wlTaskTray, disable);          // disables system trays

      dwl.wlDisableKey(0, (int)Keys.Tab, dwl.MOD_ALT, disable);  // disable Alt+Tab
      dwl.wlDisableKey(0, (int)Keys.Escape, dwl.MOD_CONTROL, disable);  // disable Ctrl+Esc
      dwl.wlDisableKey(0, (int)Keys.F1, dwl.MOD_ALL, disable); // MOD_ALL = also with Ctrl,Alt,Shift,Win Keys
      dwl.wlDisableKey(0, (int)Keys.F11, 0, disable);      // disable F11
      dwl.wlDisableKey(0, 0, dwl.MOD_WIN, disable);         // disables all WIN keys
      if (dwl.wlIsDwlInstalled() == 1)                    // only if dwlgina is installed
        dwl.wlDisableKey(0, (int)Keys.Delete, dwl.MOD_CONTROL | dwl.MOD_ALT, disable);

      // disables right mouse button only on taskbar window
      // MOD_ALL = disables Key also with Ctrl, Alt, Shift and Win Keys
      int TBar = dwl.wlGetItemHandle(dwl.wlTaskBar);
      dwl.wlDisableKey(TBar, (int)Keys.RButton, dwl.MOD_ALL, disable);
    }

    public void OnKeyDown(int userdata, int hwnd, int down, int vk, int mf)
    {
      Keys Key = (Keys)vk;
      if (dwl.wlIsKeyDisabled(0, vk, mf) == 1)
      {
        string K = "";
        dwl.wlVkToStr("",vk,mf,ref K);
        AddInfo(string.Format("Sorry, but key: {0} is disabled",K));
      }

      // Ctrl+Shift+T to enable and disable keys
      if (Key == Keys.T && mf == (dwl.MOD_CONTROL | dwl.MOD_SHIFT))
      {
        if (DISABLE == 1)
        {
          DISABLE = 0;
          AddInfo("Keys enabled");
        }
        else
        {
          DISABLE = 1;
          AddInfo("Keys disabled");
        }
        DisableKeys(DISABLE);
      }

      // detect key Ctrl+Alt+Win+Shift+A (only an example)
      if (Key == Keys.A &&
        mf == (dwl.MOD_WIN | dwl.MOD_CONTROL | dwl.MOD_ALT | dwl.MOD_SHIFT))
        AddInfo("'hand break' key pressed :-))");
    }

    private void InitdWinlock()
    {
      AddInfo("dWinlock core example program");
      AddInfo("(C) 2002-2008 Kassl GmbH (http://www.kassl.de)");
      AddInfo("");
      AddInfo("Following keys are system wide disabled:");
      AddInfo("Alt+Tab");
      AddInfo("Ctrl+Esc");
      AddInfo("Win keys");
      AddInfo("F1 with all modifiers (Ctrl,Alt,Shift,Win)");
      AddInfo("F11 without modifiers");
      AddInfo("Right mouse button on task bar");
      AddInfo("and also Ctrl+Alt+Del if dwl is installed");
      AddInfo("");
      AddInfo("Press Ctrl+Shift+T to toggle (enable/disable)");
      AddInfo("");
      DisableKeys(DISABLE);
      dwlOnKeyCallBack myCallBack = new dwlOnKeyCallBack(OnKeyDown);
      dwl.SetKeyCallback(myCallBack, 0, dwl.kDownEvents);

      label1.Visible = false;
      bInstallGina.Enabled = dwl.wlIsNTSystem() == 1;
      if (dwl.wlIsDwlInstalled() == 0)
      {
        bInstallGina.Text = "Install dwl";
        label1.Visible = true;
      }
      else
        bInstallGina.Text = "Uninstall dwl";
    }

    private void WinForm_Load(object sender, EventArgs e)
    {
      InitdWinlock();
    }

    private void bInstallGina_Click(object sender, EventArgs e)
    {
      label1.Visible = false;
      if (dwl.wlIsDwlInstalled() == 0)
      {
        if (dwl.wlInstallDwl(0) == 1)
          bInstallGina.Text = "Uinstall dwl";
      }
      else
      {
        if (dwl.wlUninstallDwl(0) == 1)
          bInstallGina.Text = "Install dwl";
      }
    }
  

		[STAThread]
		static void Main()
		{
			Application.Run(new WinForm());
		}

	}
}
