using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace DwlCoreSample
{
  public partial class Form1 : Form
  {
    private int DISABLE = 1;
    private readonly string NL = Environment.NewLine;
    
    public Form1()
    {
      InitializeComponent();
    }
    
    private void AddInfo(string info)
    {
      textBox1.AppendText(info + NL);
    }

    private void DisableKeys(int disable)
    {
      dwl.wlDisableItem(dwl.wlShutdown, disable);          // disables shutdown and reboot
      dwl.wlDisableItem(dwl.wlTaskTray, disable);          // disables system trays

      dwl.wlDisableKey(0, (int)Keys.Tab, dwl.MOD_ALT, disable);  // disable Alt+Tab
      dwl.wlDisableKey(0, (int)Keys.Escape, dwl.MOD_CONTROL, disable);  // disable Ctrl+Esc
      dwl.wlDisableKey(0, (int)Keys.F1, dwl.MOD_ALL, disable); // MOD_ALL = also with Ctrl,Alt,Shift,Win Keys
      dwl.wlDisableKey(0, (int)Keys.F11, 0, disable);      // disable F11
      dwl.wlDisableKey(0, 0, dwl.MOD_WIN, disable);         // disables all WIN keys
      if (dwl.wlIsDwlInstalled() == 1)                    // only if dwlgina is installed
        dwl.wlDisableKey(0, (int)Keys.Delete, dwl.MOD_CONTROL | dwl.MOD_ALT, disable);

      // disables right mouse button only on taskbar window
      // MOD_ALL = disables Key also with Ctrl, Alt, Shift and Win Keys
      int TBar = dwl.wlGetItemHandle(dwl.wlTaskBar);
      dwl.wlDisableKey(TBar, (int)Keys.RButton, dwl.MOD_ALL, disable);
    }

    public void OnKeyDown(int userdata, int hwnd, int down, int vk, int mf)
    {
      Keys Key = (Keys)vk;
      if (dwl.wlIsKeyDisabled(0, vk, mf) == 1)
      {
        string K = "";
        dwl.wlVkToStr("",vk,mf,ref K);
        AddInfo(string.Format("Sorry, but key: {0} is disabled",K));
      }

      // Ctrl+Shift+T to enable and disable keys
      if (Key == Keys.T && mf == (dwl.MOD_CONTROL | dwl.MOD_SHIFT))
      {
        if (DISABLE == 1)
        {
          DISABLE = 0;
          AddInfo("Keys enabled");
        }
        else
        {
          DISABLE = 1;
          AddInfo("Keys disabled");
        }
        DisableKeys(DISABLE);
      }

      // detect key Ctrl+Alt+Win+Shift+A (only an example)
      if (Key == Keys.A &&
        mf == (dwl.MOD_WIN | dwl.MOD_CONTROL | dwl.MOD_ALT | dwl.MOD_SHIFT))
        AddInfo("'hand break' key pressed :-))");
    }

    private void InitdWinlock()
    {
      AddInfo("dWinlock core example program");
      AddInfo("(C) 2002-2008 Kassl GmbH (http://www.kassl.de)");
      AddInfo("");
      AddInfo("Following keys are system wide disabled:");
      AddInfo("Alt+Tab");
      AddInfo("Ctrl+Esc");
      AddInfo("Win keys");
      AddInfo("F1 with all modifiers (Ctrl,Alt,Shift,Win)");
      AddInfo("F11 without modifiers");
      AddInfo("Right mouse button on task bar");
      AddInfo("and also Ctrl+Alt+Del if dwl is installed");
      AddInfo("");
      AddInfo("Press Ctrl+Shift+T to toggle (enable/disable)");
      AddInfo("");
      DisableKeys(DISABLE);
      dwlOnKeyCallBack myCallBack = new dwlOnKeyCallBack(OnKeyDown);
      dwl.SetKeyCallback(myCallBack, 0, dwl.kDownEvents);

      label1.Visible = false;
      bInstallGina.Enabled = dwl.wlIsNTSystem() == 1;
      if (dwl.wlIsDwlInstalled() == 0)
      {
        bInstallGina.Text = "Install dwl";
        label1.Visible = true;
      }
      else
        bInstallGina.Text = "Uninstall dwl";
    }

    private void Form1_Load(object sender, EventArgs e)
    {
      InitdWinlock();
    }

    private void bInstallGina_Click(object sender, EventArgs e)
    {
      label1.Visible = false;
      if (dwl.wlIsDwlInstalled() == 0)
      {
        if (dwl.wlInstallDwl(0) == 1)
          bInstallGina.Text = "Uinstall dwl";
      }
      else
      {
        if (dwl.wlUninstallDwl(0) == 1)
          bInstallGina.Text = "Install dwl";
      }
    }
    
        
  }
}