﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace DisableKeys
{
    
  public partial class Form1 : Form
  {
    private dwl Keymonitor; 
    private string None = "None";
    public Form1()
    {
      InitializeComponent();
      Keymonitor = new dwl();
      Keymonitor.KeyDown   += new dwlKeyEventHandler(dwlKeyDown);    
    }
    
    private void dwlKeyDown( object sender, dwlKeyEventArgs e)
    {
     string KeyStr = "";
     dwl.wlVkToStr("", (int) e.KeyCode,dwl.KeysToMF(e.Modifiers),ref KeyStr);
     tKeytext.Text  =  KeyStr;    
    }

    
    private void UpdateDisableKeys(string[] Strings)
    {
       string dummy= "";
       string rt;
       int d  = 0;
       int vk = 0;
       int mf = 0;
       dwl.wlDisableKey(0,0,0,0);  // reset all disabled keys;
       foreach (string r in Strings)
       {
         rt = r.Trim();
         
         if (rt != string.Empty)
         {
           dwl.wlStrToVk(rt,dummy,d,ref vk,ref mf);
           if (vk != 0)
              dwl.wlDisableKey(0,vk,mf,1);
           else
           {
             MessageBox.Show(String.Format("can not disable key {0}",r));
             return;
           }               
         }
       }
    }

    private void bClear_Click(object sender, EventArgs e)
    {
      textBox1.Clear();
      UpdateDisableKeys(textBox1.Lines);
    }

    private void bUpdate_Click(object sender, EventArgs e)
    {
      UpdateDisableKeys(textBox1.Lines);  
    }

    private void bDisable_Click(object sender, EventArgs e)
    {
       if (tKeytext.Text != None)
       {
        textBox1.AppendText(tKeytext.Text+Environment.NewLine);
        UpdateDisableKeys(textBox1.Lines);
       }
    }
  }
}
