using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace KeyMonitor
{
  
  public partial class KeyForm : Form
  {
    private dwl Keymonitor; 
    
    public KeyForm()
    {
      InitializeComponent();
      Keymonitor = new dwl();
      Keymonitor.KeyDown   += new dwlKeyEventHandler(dwlKeyDown);
      Keymonitor.MouseDown += new dwlMouseEventHandler(dwlMouseDown);
    }

    private void dwlMouseDown(object sender, dwlMouseEventArgs e)
    {
      lKey.Text      = e.Button.ToString();
      lModifier.Text = e.Modifiers.ToString();
      lWindow.Text   = e.Wnd.ToString();
    }
    
    private void dwlKeyDown( object sender, dwlKeyEventArgs e)
    {
     lKey.Text      = e.KeyCode.ToString();
     lModifier.Text = e.Modifiers.ToString();
     lWindow.Text   = e.Wnd.ToString();
    }

  }
}