//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "CoreMain.h"
#include "../../dwlcore.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::AddInfo(String info)
{
  Memo1->Lines->Add(info);
}

void __fastcall DisableKeys(int disable)
{
  wlDisableItem(wlTaskTray,disable);          // disables system trays

  wlDisableKey(0,VK_TAB, MOD_ALT,disable);  // disable Alt+Tab
  wlDisableKey(0,VK_ESCAPE, MOD_CONTROL,disable);  // disable Ctrl+Esc
  wlDisableKey(0,VK_F1,MOD_ALL,disable); // MOD_ALL = also with Ctrl,Alt,Shift,Win Keys
  wlDisableKey(0,VK_F11,0,disable);      // disable F11
  wlDisableKey(0,0,MOD_WIN,disable);     // disables all WIN keys
  if (wlIsDwlInstalled() == 1)            // only if dwl is installed
    wlDisableKey(0,VK_DELETE,MOD_CONTROL | MOD_ALT,disable);

  // disables right mouse button only on taskbar window
  // MOD_ALL = disables Key also with Ctrl, Alt, Shift and Win Keys
  HWND TBar = wlGetItemHandle(wlTaskBar);
  wlDisableKey(TBar,VK_RBUTTON,MOD_ALL,disable);
}



void __fastcall TForm1::Keydown(TMessage& Msg)
{
  HWND wnd = (HWND)Msg.WParam;
  int  VK  = Msg.LParamLo;
  int  MF  = Msg.LParamHi;
  if (wlIsKeyDisabled(0,VK,MF) == 1)
    AddInfo("Sorry, but this key is disabled");

  // detect key Ctrl+Alt+Win+Shift+A (only an example)
  if (VK == (int)'A' && (MF == MOD_WIN | MOD_CONTROL | MOD_ALT | MOD_SHIFT))
    AddInfo("'hand break' key pressed :-)");

  // Ctrl+Shift+T to enable and disable keys
  if (VK == (int)'T' && (MF == MOD_CONTROL | MOD_SHIFT))
  {
    if (DISABLE == 1)
    {
      DISABLE = 0;
      AddInfo("Keys enabled");
    }
    else
    {
      DISABLE = 1;
      AddInfo("Keys disabled");
    }
    DisableKeys(DISABLE);
  }

  // if Alt+Shift+W is pressed show window name
   if (VK == (int) 'W' && (MF == MOD_CONTROL | MOD_ALT))
   {
     char Buffer[255];
     GetClassName(wnd, Buffer, sizeof(Buffer));
     String Info = "Ctrl+Shift+W pressed in window: ";
     Info += Buffer;
     AddInfo(Info);
   }
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  AddInfo("dWinlock core example");
  AddInfo("(c) 2002-2008 Kassl GmbH (http://www.kassl.de)");
  AddInfo("");
  AddInfo("Following keys are system wide disabled:");
  AddInfo("Alt+Tab");
  AddInfo("Ctrl+Esc");
  AddInfo("Win keys");
  AddInfo("F1 with all modifiers (Ctrl,Alt,Shift,Win)");
  AddInfo("F11 without modifiers");
  AddInfo("Right mouse button on task bar");
  AddInfo("and also Ctrl+Alt+Del if dwl is installed");
  AddInfo("");
  AddInfo("Press Shift+Ctrl+T to toggle (enable/disable)");
  AddInfo("");
  DISABLE = 1;
  wlSetKeyPostMessage(Handle,WM_DWLKEYDOWN,0); // we want key down events but not key up events
  DisableKeys(DISABLE);                     // disable keys
  Label1->Visible = false;
  bGinaInstall->Enabled = wlIsNTSystem() == 1;
  if (wlIsDwlInstalled() == 0)
  {
    bGinaInstall->Caption = "Install dwl";
    Label1->Visible = true;
  }
  else
  {
    bGinaInstall->Caption = "Uninstall dwl";
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::bGinaInstallClick(TObject *Sender)
{
  Label1->Visible = false;
  if (wlIsDwlInstalled() == 0)
  {
    if (wlInstallDwl(0) == 1)
      bGinaInstall->Caption = "Uinstall dwl";
  }
  else
  {
    if (wlUninstallDwl(0) == 1)
      bGinaInstall->Caption = "Install dwl";
  }

}
//---------------------------------------------------------------------------
