// dWinlock API 


#include "stdafx.h"


#include "dwlcore.h"


static HMODULE hdGina = NULL;
static int dwlmessage = 0;

typedef int  (__stdcall *lpfnVersion)(int RequestedVersion);
typedef int  (__stdcall *lpfnDisableKey)(HWND WindowHandle, int vk, int fsModifiers, int disable);
typedef int  (__stdcall *lpfnIsKeyDisabled)(HWND WindowHandle, int vk, int shift);
typedef int  (__stdcall *lpfnGetDisabledKey)(int i, HWND *pWindowHandle, int *pvk, int *pshift);
typedef void (__stdcall *lpfnSetKeySendMessage)(HWND hWnd, int KeyDownMessageID, int KeyUpMessageID);
typedef void (__stdcall *lpfnSetKeyPostMessage)(HWND hWnd, int KeyDownMessageID, int KeyUpMessageID);
typedef void (__stdcall *lpfnSetKeyCallback)(lpfnDwlKeyCallback CallbackFunc, int UserData, int Flags);
typedef void (__stdcall *lpfnRestoreAll)(void);
typedef void (__stdcall *lpfnDisableItem)(int Item,int disable);
typedef int  (__stdcall *lpfnIsItemDisabled)(int Item);
typedef HWND (__stdcall *lpfnGetItemHandle)(int Item);
typedef int  (__stdcall *lpfnInstallDwl)(int Flags);
typedef int  (__stdcall *lpfnUninstallDwl)(int Flags);
typedef int  (__stdcall *lpfnIsDwlInstalled)(void);
typedef int  (__stdcall *lpfnIsNTSystem)(void);
typedef int  (__stdcall *lpfnNeedDwlInstall)(void);
typedef int  (__stdcall *lpfnExitWindows)(int Flags);
typedef int  (__stdcall *lpfnWinVersion)(void);
typedef int  (__stdcall *lpfnGetKeyState)(int Key);
typedef void (__stdcall *lpfnSetKeyState)(int Key, int TurnOn);
typedef int  (__stdcall *lpfnIsAdmin)(void);
typedef void (__stdcall *lpfnEnableAutologin)(char *DefUser, char* Pass, int Enable);
typedef int  (__stdcall *lpfnMapScancode)(int InputCode,int OutputCode);
typedef void (__stdcall *lpfnDisableDesktopIcon)(int index);
typedef int  (__stdcall *lpfnDesktopIconCount)(void);
typedef void (__stdcall *lpfnRestoreDesktopIcons)(void);
typedef void (__stdcall *lpfnExit)(void);
typedef int  (__stdcall *lpfnSetStartMenu)(int Wnd);
typedef int  (__stdcall *lpfnReplaceKey)(HWND WindowHandle, int vk, int fsModifiers, int vk_out, int fsMod_out);
typedef int  (__stdcall *lpfnGetDisabledMessage)(int i, HWND* window, int* MsgID);
typedef int  (__stdcall *lpfnIsMessageDisabled)(HWND window, int MsgID);
typedef int  (__stdcall *lpfnDisableMessage)(HWND window, int MsgID, int disable);


lpfnVersion _wlVersion = NULL;
lpfnDisableKey _wlDisableKey= NULL;
lpfnIsKeyDisabled _wlIsKeyDisabled = NULL;
lpfnGetDisabledKey _wlGetDisabledKey = NULL;
lpfnSetKeySendMessage _wlSetKeySendMessage = NULL;
lpfnSetKeyPostMessage _wlSetKeyPostMessage = NULL;
lpfnSetKeyCallback _wlSetKeyCallback = NULL;
lpfnRestoreAll _wlRestoreAll = NULL;
lpfnDisableItem _wlDisableItem = NULL;
lpfnIsItemDisabled _wlIsItemDisabled = NULL;
lpfnGetItemHandle _wlGetItemHandle = NULL;
lpfnInstallDwl _wlInstallDwl = NULL;
lpfnUninstallDwl _wlUninstallDwl = NULL;
lpfnIsDwlInstalled _wlIsDwlInstalled = NULL;
lpfnIsNTSystem _wlIsNTSystem = NULL;
lpfnNeedDwlInstall _wlNeedDwlInstall = NULL;
lpfnExitWindows _wlExitWindows = NULL;
lpfnWinVersion _wlWinVersion = NULL;
lpfnGetKeyState _wlGetKeyState = NULL;
lpfnSetKeyState _wlSetKeyState = NULL;
lpfnIsAdmin _wlIsAdmin = NULL;
lpfnEnableAutologin _wlEnableAutologin = NULL;
lpfnMapScancode _wlMapScancode = NULL;
lpfnDisableDesktopIcon _wlDisableDesktopIcon = NULL;
lpfnDesktopIconCount _wlDesktopIconCount = NULL;
lpfnRestoreDesktopIcons _wlRestoreDesktopIcons = NULL;
lpfnExit _wlExit = NULL;
lpfnSetStartMenu _wlSetStartMenu = NULL;
lpfnReplaceKey _wlReplaceKey = NULL;
lpfnGetDisabledMessage _wlGetDisabledMessage = NULL;
lpfnIsMessageDisabled _wlIsMessageDisabled = NULL;
lpfnDisableMessage  _wlDisableMessage = NULL;


FARPROC GetProcAddr(HMODULE hModule, LPCSTR PName)
{
  FARPROC  P = GetProcAddress(hModule,PName);
  if (P == NULL)
    MessageBox(GetFocus(), strcpy("Could find method ",PName), "dWinlock Error", MB_OK | MB_ICONERROR);
  return P;
}

int dwlInit(void){
  if(hdGina) return 1;
  hdGina = LoadLibrary("dwlgina3.dll");
  if(!hdGina)
  {
    if (dwlmessage == 0)
      MessageBox(GetFocus(), "Could not load dwlgina3.dll library", "dWinlock Error", MB_OK | MB_ICONERROR);
    dwlmessage = 1;
    return 0;
  }

#define GPA(a) GetProcAddr(hdGina,a)
  _wlVersion = (lpfnVersion)GPA("wlVersion");
  _wlDisableKey = (lpfnDisableKey)GPA("wlDisableKey");
  _wlIsKeyDisabled = (lpfnIsKeyDisabled)GPA("wlIsKeyDisabled");
  _wlGetDisabledKey = (lpfnGetDisabledKey)GPA("wlGetDisabledKey");
  _wlSetKeySendMessage = (lpfnSetKeySendMessage)GPA("wlSetKeySendMessage");
  _wlSetKeyPostMessage = (lpfnSetKeyPostMessage)GPA("wlSetKeyPostMessage");
  _wlSetKeyCallback = (lpfnSetKeyCallback)GPA("wlSetKeyCallback");
  _wlRestoreAll = (lpfnRestoreAll)GPA("wlRestoreAll");
  _wlDisableItem = (lpfnDisableItem)GPA("wlDisableItem");
  _wlIsItemDisabled = (lpfnIsItemDisabled)GPA("wlIsItemDisabled");
  _wlGetItemHandle = (lpfnGetItemHandle)GPA("wlGetItemHandle");
  _wlInstallDwl = (lpfnInstallDwl)GPA("wlInstallDwl");
  _wlUninstallDwl = (lpfnUninstallDwl)GPA("wlUninstallDwl");
  _wlIsDwlInstalled = (lpfnIsDwlInstalled)GPA("wlIsDwlInstalled");
  _wlIsNTSystem = (lpfnIsNTSystem)GPA("wlIsNTSystem");
  _wlNeedDwlInstall = (lpfnNeedDwlInstall)GPA("wlNeedDwlInstall");
  _wlExitWindows = (lpfnExitWindows)GPA("wlExitWindows");
  _wlWinVersion = (lpfnWinVersion)GPA("wlWinVersion");
  _wlGetKeyState = (lpfnGetKeyState)GPA("wlGetKeyState");
  _wlSetKeyState = (lpfnSetKeyState)GPA("wlSetKeyState");
  _wlIsAdmin = (lpfnIsAdmin)GPA("wlIsAdmin");
  _wlEnableAutologin = (lpfnEnableAutologin)GPA("wlEnableAutologin");
  _wlMapScancode = (lpfnMapScancode)GPA("wlMapScancode");
  _wlDisableDesktopIcon = (lpfnDisableDesktopIcon)GPA("wlDisableDesktopIcon");
  _wlDesktopIconCount = (lpfnDesktopIconCount)GPA("wlDesktopIconCount");
  _wlRestoreDesktopIcons = (lpfnRestoreDesktopIcons)GPA("wlRestoreDesktopIcons");
  _wlExit = (lpfnExit)GPA("wlExit");
  _wlSetStartMenu = (lpfnSetStartMenu)GPA("wlSetStartMenu");
  _wlReplaceKey =(lpfnReplaceKey)GPA("wlReplaceKey");
  _wlGetDisabledMessage = (lpfnGetDisabledMessage)GPA("wlGetDisabledMessage");
  _wlIsMessageDisabled = (lpfnIsMessageDisabled)GPA("wlIsMessageDisabled");
  _wlDisableMessage = (lpfnDisableMessage)GPA("wlDisableMessage");
#undef GPA
  return 1;
}

#define begin {  if (! dwlInit()) return;
#define beginreturn {  if (! dwlInit()) return 0; return
#define end }
int wlVersion(int RequestedVersion)
beginreturn _wlVersion(RequestedVersion); end

void wlExit(void)
begin _wlExit; end

int  wlDisableKey(HWND WindowHandle, int vk, int fsModifiers, int disable)
beginreturn _wlDisableKey(WindowHandle, vk, fsModifiers, disable); end

int  wlIsKeyDisabled(HWND WindowHandle, int vk, int shift)
beginreturn _wlIsKeyDisabled(WindowHandle, vk, shift); end

int  wlGetDisabledKey(int i, HWND *pWindowHandle, int *pvk, int *pshift)
beginreturn _wlGetDisabledKey(i, pWindowHandle, pvk, pshift); end

void  wlSetKeySendMessage(HWND hWnd, int KeyDownMessageID, int KeyUpMessageID)
begin _wlSetKeySendMessage(hWnd, KeyDownMessageID, KeyUpMessageID); end

void  wlSetKeyPostMessage(HWND hWnd, int KeyDownMessageID, int KeyUpMessageID)
begin _wlSetKeyPostMessage(hWnd, KeyDownMessageID, KeyUpMessageID); end

void  wlSetKeyCallback(lpfnDwlKeyCallback CallbackFunc, int UserData, int Flags)
begin _wlSetKeyCallback(CallbackFunc, UserData, Flags); end

void  wlRestoreAll(void)
begin _wlRestoreAll(); end

void  wlDisableItem(int Item,int disable)
begin _wlDisableItem(Item,disable); end

int  wlIsItemDisabled(int Item)
beginreturn _wlIsItemDisabled(Item); end

HWND wlGetItemHandle(int Item)
beginreturn _wlGetItemHandle(Item); end

int  wlInstallDwl(int Flags)
beginreturn _wlInstallDwl(Flags); end

int  wlUninstallDwl(int Flags)
beginreturn _wlUninstallDwl(Flags); end

int  wlIsDwlInstalled(void)
beginreturn _wlIsDwlInstalled(); end

int  wlIsNTSystem(void)
beginreturn _wlIsNTSystem(); end

int  wlNeedDwlInstall(void)
beginreturn _wlNeedDwlInstall(); end

int  wlExitWindows(int Flags)
beginreturn _wlExitWindows(Flags); end

int  wlWinVersion(void)
beginreturn _wlWinVersion(); end

int  wlGetKeyState(int Key)
beginreturn _wlGetKeyState(Key); end

void wlSetKeyState(int Key, int TurnOn)
begin _wlSetKeyState(Key, TurnOn); end

int  wlIsAdmin(void)
beginreturn _wlIsAdmin(); end

void wlEnableAutologin(char *DefUser, char* Pass, int Enable)
begin _wlEnableAutologin(DefUser,Pass, Enable); end

int  wlMapScancode(int InputCode,int OutputCode)
beginreturn _wlMapScancode(InputCode,OutputCode); end

void wlDisableDesktopIcon(int index)
begin _wlDisableDesktopIcon(index); end

int  wlDesktopIconCount(void)
beginreturn _wlDesktopIconCount(); end

void wlRestoreDesktopIcons(void)
begin _wlRestoreDesktopIcons(); end

int  wlSetStartMenu(int Wnd)
beginreturn _wlSetStartMenu(Wnd); end

int  wlReplaceKey(HWND WindowHandle, int vk, int fsModifiers, int vk_out, int fsMod_out)
beginreturn _wlReplaceKey(WindowHandle, vk, fsModifiers, vk_out, fsMod_out); end

int  wlGetDisabledMessage(int i, HWND* window, int* MsgID)
beginreturn _wlGetDisabledMessage( i, window, MsgID); end

int  wlIsMessageDisabled(HWND window, int MsgID)
beginreturn _wlIsMessageDisabled(window, MsgID); end

int  wlDisableMessage(HWND window, int MsgID, int disable)
beginreturn _wlDisableMessage(window, MsgID, disable); end

void dwlExit(void){
  if(!hdGina) return;
  wlExit();
  FreeLibrary(hdGina);
  hdGina = NULL;
  _wlVersion = NULL;
  _wlDisableKey = NULL;
  _wlIsKeyDisabled = NULL;
  _wlGetDisabledKey = NULL;
  _wlGetItemHandle = NULL;
  _wlSetKeySendMessage = NULL;
  _wlSetKeyPostMessage = NULL;
  _wlSetKeyCallback = NULL;
  _wlRestoreAll = NULL;
  _wlDisableItem = NULL;
  _wlIsItemDisabled = NULL;
  _wlInstallDwl = NULL;
  _wlUninstallDwl = NULL;
  _wlIsDwlInstalled = NULL;
  _wlIsNTSystem = NULL;
  _wlNeedDwlInstall = NULL;
  _wlExitWindows = NULL;
  _wlWinVersion = NULL;
  _wlGetKeyState = NULL;
  _wlSetKeyState = NULL;
  _wlIsAdmin = NULL;
  _wlEnableAutologin = NULL;
  _wlMapScancode = NULL;
  _wlDisableDesktopIcon = NULL;
  _wlDesktopIconCount = NULL;
  _wlRestoreDesktopIcons = NULL;
  _wlExit = NULL;
  _wlSetStartMenu = NULL;
  _wlReplaceKey = NULL;
  _wlGetDisabledMessage = NULL;
  _wlIsMessageDisabled = NULL;
  _wlDisableMessage = NULL;
}
