#ifndef DWLCORE_H
#define DWLCORE_H
#include <windows.h>
#ifdef __cplusplus
extern "C"{
#endif

#define	DWL_MAJORVERSION  3
#define DWL_SUBVERSION   02
#define	DWL_VERSION     ((DWL_MAJORVERSION << 16) | DWL_SUBVERSION)

#define MOD_ALL         255

// Constants for disable Desktop items. see also procedure wlDisableItem
#define wlTaskBar       1
#define wlDesktop       2
#define wlStartbutton   3
#define wlTaskLinks     4
#define wlTaskTray      5
#define wlTaskRebar     6
#define wlAccessibility 7
#define wlAccHighContrast 8
#define wlAccFilterKeys   9
#define wlAccMouseKey     10
#define wlAccStickyKeys   11
#define wlAccToggleKeys   12
#define wlShutdown        13

// dwlGinaInstallFlags to use with wlInstallGina and wlUninstallGina
#define giForceInstall    1
#define giForceUninstall  2
#define giForceReboot     4
#define giNoReboot        8
#define giNoWarnings   0x10

// flags for wlSetKeyCallback
#define kDownEvents       1
#define kUpEvents         2
#define kMouseDownEvents  4
#define kMouseUpEvents    8

// return values of wlWinVersion
#define vWinunknown       1
#define vWin95            2
#define vWin98            3
#define vWinMe            4
#define vWinNT            5
#define vWin2000          6
#define vWinXP            7
#define vWinVista         8

// callback function definition for wlSetKeyCallback(..)
typedef void (__stdcall *lpfnDwlKeyCallback)(int UserData, HWND hWnd, int Down, int Key, int Shift);
typedef int  (__stdcall *lpfndwlQueryEndSessionCallback)(int UserData, int wParam, int lParam);

int wlVersion(int RequestedVersion);
int wlDisableKey(HWND WindowHandle, int vk, int fsModifiers, int disable);
int wlIsKeyDisabled(HWND WindowHandle, int vk, int shift);
int wlGetDisabledKey(int i, HWND *pWindowHandle, int *pvk, int *pshift);
void wlSetKeySendMessage(HWND hWnd, int KeyDownMessageID, int KeyUpMessageID);
void wlSetKeyPostMessage(HWND hWnd, int KeyDownMessageID, int KeyUpMessageID);
void wlSetKeyCallback(lpfnDwlKeyCallback CallbackFunc, int UserData, int Flags);
void wlRestoreAll(void);
void wlDisableItem(int Item,int disable);
int wlIsItemDisabled(int Item);
HWND wlGetItemHandle(int Item);
int wlInstallDwl(int Flags);
int wlUninstallDwl(int Flags);
int wlIsDwlInstalled(void);
int wlIsNTSystem(void);
int wlNeedDwlInstall(void);
int wlExitWindows(int Flags);
int wlWinVersion(void);
int wlGetKeyState(int Key);
void wlSetKeyState(int Key, int TurnOn);
int wlIsAdmin(void);
void wlEnableAutologin(char *DefUser, char* Pass, int Enable);
int wlMapScancode(int InputCode,int OutputCode);
void wlDisableDesktopIcon(int index);
int wlDesktopIconCount(void);
void wlRestoreDesktopIcons(void);
void wlExit(void);
int wlSetStartMenu(int Wnd);
int wlReplaceKey(HWND WindowHandle, int vk, int fsModifiers, int vk_out, int fsMod_out);
int wlGetDisabledMessage(int i, HWND* window, int* MsgID);
int wlIsMessageDisabled(HWND window, int MsgID);
int wlDisableMessage(HWND window, int MsgID, int disable);

int dwlInit(void);
void dwlExit(void);

#ifdef __cplusplus
  }
#endif
#endif