unit main;
{******************************************************************************
*  Copyright  2003  Dipl.-Ing. H.-D. Kassl  All rights reserved.
*
*  Kassl GmbH
*  27607 Langen (Germany)
*  phone: +49 4743 911021
*  fax  : +49 4743 911022
*
*  http://www.dwinlock.kassl.de
*  e-mail: dWinlock@Kassl.de
*
*  this program is an example that shows
*  how to use the dWinlock core unit "dwlcore"
******************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Panel1: TPanel;
    Label1: TLabel;
    procedure FormShow(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    LastClassName : string;
    procedure OnDwlKeyDown(Wnd: HWND; Down,Key,Shift: integer); {$IFNDEF CIL} stdcall; {$ENDIF}
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses
  dwlcore;

procedure TForm1.FormShow(Sender: TObject);
begin
  left := 0;
  top  := 0;
  LastClassname := '';
  wlSetObjKeyCallback(OnDwlKeyDown,kDownEvents); // Set callback function
                                                 // we want only key down events
end;

procedure TForm1.OnDwlKeyDown(Wnd: HWND; Down, Key, Shift: integer);
var
  ClassName : string;
begin
  if (Wnd = Memo1.Handle) or (Wnd = handle) then // not in own program
    exit;                             // we don't want to show own class name

  ClassName := GetClassName(Wnd);     // get class name
  if Memo1.Lines.Count > 30 then      // maximal 30 items
    Memo1.clear;
  if LastClassname <> Classname then  // only if new class name
    Memo1.Lines.add(ClassName);       // show class name
  LastClassName := ClassName;         // save class name
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
{$IFDEF CIL}
  wlExit; // normally not necessary,
          // but if you don't call this function the program craches
          // on shutdown under Windows 98 if the program is compiled with
          // Delphi 8 .Net (VCL Framework) (may be a internal Delphi 8 problem)
{$ENDIF}
end;

end.
