unit main;
{******************************************************************************
*  Copyright  2002-2008  Dipl.-Ing. H.-D. Kassl  All rights reserved.
*
*  Kassl GmbH
*  27607 Langen (Germany)
*  phone: +49 4743 911021
*  fax  : +49 4743 911022
*
*  http://www.dwinlock.kassl.de
*  e-mail: dWinlock@Kassl.de
*
*  This program is an example that shows how to use the
*  dWinlock core unit "dwlcore"
*
*  Delphi versions: 5,6,7,2005,2006, 2007 (Win 32 and VCL.Net)
******************************************************************************}

interface

uses
  Windows, Classes, SysUtils, Forms,
  StdCtrls, ExtCtrls, Controls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Panel1: TPanel;
    bGinaInstall: TButton;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure bGinaInstallClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    Disable : integer;
    procedure DwlKeyDownEvent(Wnd: Hwnd; Down, VK, MF: integer); {$IFNDEF CIL} stdcall; {$ENDIF}
    procedure AddInfo(Info: string);
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses
  dwlcore;

procedure DisableKeys(disable : integer);
var
 Wnd: HWND;
begin
  wlDisableItem(wlTaskTray,disable);          // disables system trays

  wlDisableKey(0,VK_TAB, MOD_ALT,disable);  // disable Alt+Tab
  wlDisableKey(0,VK_ESCAPE, MOD_CONTROL,disable);  // disable Ctrl+Esc
  wlDisableKey(0,VK_F1,MOD_ALL,disable); // MOD_ALL = also with Ctrl,Alt,Shift,Win Keys
  wlDisableKey(0,VK_F11,0,disable);      // disable F11
  wlDisableKey(0,0,MOD_WIN,disable);     // disables all WIN keys
  if wlIsDwlInstalled = 1 then          // only if dwlgina is installed
    wlDisableKey(0,VK_DELETE,MOD_CONTROL or MOD_ALT,disable);

  // disables right mouse button only on taskbar window
  // MOD_ALL = disables Key also with Ctrl, Alt, Shift and Win Keys
  Wnd := wlGetItemHandle(wlTaskbar);
  wlDisableKey(Wnd,VK_RBUTTON,MOD_ALL,disable);
end;

procedure TForm1.AddInfo(Info : string);
begin
  Memo1.Lines.Add(Info);
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
  AddInfo('dWinlock core example');
  AddInfo('(c) 2002-2008 Kassl GmbH (http://www.kassl.de)');
  AddInfo(format('dwlgina version: %d.%d',[HIWORD(wlVersion),LOWORD(wlVersion)]));
  AddInfo('');
  AddInfo('Following keys are system wide disabled:');
  AddInfo('Alt+Tab');
  AddInfo('Ctrl+Esc');
  AddInfo('Win keys');
  AddInfo('F1 with all modifiers (Ctrl,Alt,Shift,Win)');
  AddInfo('F11 without modifiers');
  AddInfo('Right mouse button on task bar');
  AddInfo('and also Ctrl+Alt+Del if dwl is installed');
  AddInfo('');
  AddInfo('Press Shift+Ctrl+T to toggle (enable/disable)');
  AddInfo('');
  Disable := 1;
  wlSetObjKeyCallback(dwlKeydownEvent,kDownEvents); // we want key down events but not key up events
  DisableKeys(Disable);                           // disable keys
  Label1.Visible := false;
  bGinaInstall.Enabled   := wlIsNtSystem = 1;
  if wlIsDwlInstalled = 0 then
  begin
    bGinaInstall.Caption := 'Install dwl';
    Label1.Visible := true;
  end
  else
    bGinaInstall.Caption := 'Uninstall dwl';
end;


procedure TForm1.DwlKeyDownEvent(Wnd: Hwnd; Down, VK, MF: integer);
begin
  if wlIsKeyDisabled(0,VK,MF) = 1 then
    AddInfo('Sorry, but this key is disabled to enable press Shift+Ctrl+T');

  // detect key Ctrl+Alt+Win+Shift+A (only an example)
  if (VK = Ord('A')) and (MF = MOD_WIN or MOD_CONTROL or MOD_ALT or MOD_SHIFT) then
    AddInfo('"hand break" key pressed :-)');

  // Ctrl+Shift+T to enable and disable keys
  if (VK = Ord('T')) and (MF = MOD_CONTROL or MOD_SHIFT) then
  begin
    if Disable = 1 then
    begin
      Disable := 0;
      AddInfo('Keys enabled');
      beep;
    end
    else
    begin
      Disable := 1;
      AddInfo('Keys disabled');
      beep;
    end;
    DisableKeys(Disable);
  end;

  // if Alt+Shift+W is pressed show window name
  if (VK = Ord('W')) and (MF = MOD_CONTROL or MOD_ALT) then
    AddInfo('Ctrl+Shift+W pressed in window: '+ GetClassName(Wnd));
end;

procedure TForm1.bGinaInstallClick(Sender: TObject);
begin
  if wlIsDwlInstalled = 0 then
  begin
    if wlInstallDwl(0) = 1 then
      bGinaInstall.Caption := 'Uinstall dwl'
  end
  else
    if wlUnInstallDwl(0) = 1 then
      bGinaInstall.Caption := 'Install dwl'
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
{$IFDEF CIL}
  wlExit; // normally not necessary,
          // but if you don't call this function the program crashes
          // on shutdown under Windows 98 if the program is compiled with
          // Delphi 8 .Net (VCL Framework) (may be a internal Delphi 8 problem)
{$ENDIF}
end;

end.
