unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, dwlcore, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    lKey: TLabel;
    bDisable: TButton;
    bUpdate: TButton;
    bClear: TButton;
    Label4: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure bDisableClick(Sender: TObject);
    procedure bUpdateClick(Sender: TObject);
    procedure bClearClick(Sender: TObject);
  private
    procedure dwlKeyEvent(Wnd: hwnd; Down,vk,mf: integer) stdcall;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

const
  NONE = 'None';

procedure TForm1.FormCreate(Sender: TObject);
begin
  wlSetObjKeyCallback(dwlKeyEvent,kDownEvents);
end;

function VkToStr(Window: string; VK, MF: integer): string;
begin
  wlVkToStr(pchar(Window),VK,MF,result);
  if result = '' then
    result := None;
end;

procedure TForm1.dwlKeyEvent(Wnd: hwnd; Down, vk, mf: integer);
begin
  if vk <> VK_LBUTTON then
    lKey.Caption      := VkToStr('',vk,mf);
end;

procedure UpdateDisableKeys(KeyList: TStrings);
var
 i : integer;
 Row : string;
 vk, mf : integer;
 dummy : string;
begin
  wlDisableKey(0,0,0,0);  // reset all disabled keys;
  for i := 0 to KeyList.Count-1 do
  begin
    Row := trim(KeyList[i]);
    if Row <> '' then
    begin
      wlStrToVk(KeyList[i],dummy,vk,mf);
      if vk <> 0 then
        wlDisableKey(0,vk,mf,1)
      else
      begin
        ShowMessage(format('can not disable key (%s)'#10#13'fault in line: %d',[Row,i+1]));
        break;
      end;
    end;
  end;
end;

procedure TForm1.bUpdateClick(Sender: TObject);
begin
 UpdateDisableKeys(Memo1.Lines);
end;

procedure TForm1.bClearClick(Sender: TObject);
begin
  Memo1.Lines.Clear;
  UpdateDisableKeys(Memo1.Lines);
end;


procedure TForm1.bDisableClick(Sender: TObject);
begin
  if Lkey.Caption <> None then
  begin
    Memo1.Lines.Add(Lkey.Caption);
    UpdateDisableKeys(Memo1.Lines);
  end;
end;


end.
