unit main;
{******************************************************************************
*  Copyright  2003-2008 Dipl.-Ing. H.-D. Kassl  All rights reserved.
*
*  Kassl GmbH
*  27607 Langen (Germany)
*  phone: +49 4743 911021
*  fax  : +49 4743 911022
*
*  http://www.dwinlock.kassl.de
*  e-mail: dWinlock@Kassl.de
*
*  this program is an example that shows how to use the
*  dWinlock core unit "dwlcore"
******************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    bLock: TButton;
    bUnlock: TButton;
    procedure bUnlockClick(Sender: TObject);
    procedure bLockClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}
uses
  dwlcore;

procedure LockWindows(disable: integer);
var
 hTaskBar, hProgman: HWND;
begin
  // disables desktop items
  wlDisableItem(wlTaskTray,disable);
  wlDisableItem(wlDesktop,disable);
  wlDisableItem(wlTaskLinks,disable);
  wlDisableItem(wlStartMenu,disable);
  //wlSetStartMenu(Form1.Handle);
  wlDisableItem(wlAccessibility,disable);

  // find handles for task bar and start button
  hTaskBar     := wlGetItemHandle(wlTaskBar);
  hProgman     := wlGetItemHandle(wlDesktop);

  wlDisableKey(0,0,MOD_WIN,disable);              // disables all WIN keys
  wlDisableKey(0,VK_ESCAPE, MOD_CONTROL,disable);
  wlDisableKey(0,VK_F4, MOD_ALT,disable);

  // disables all keys form desktop
  if hProgman > 0 then
    wlDisableKey(hProgman,0,MOD_ALL,disable);

  // disables all keys (mouse buttons included) for task bar
  if hTaskBar > 0 then
    wlDisableKey(hTaskBar,0, MOD_ALL,disable);

  if wlIsDwlInstalled = 1 then          // only if dwlgina is installed
    wlDisableKey(0,VK_DELETE,MOD_CONTROL or MOD_ALT,disable); // disables Ctrl+Alt+Del
end;

procedure TForm1.bUnlockClick(Sender: TObject);
begin
  wlRestoreAll;  // restore all setting (all is enabled)
end;

procedure TForm1.bLockClick(Sender: TObject);
begin
  LockWindows(1);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
{$IFDEF CIL}
  wlExit; // normally not necessary,
          // but if you don't call this function the program crash
          // on shutdown under Windows 98 if the program is compiled with
          // Delphi 8 .Net (VCL Framework) (may be a internal Delphi 8 problem)
{$ENDIF}
end;

end.
