unit DisableKeys;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, Menus, dwlcore;

type
  TDlgDisableKeys = class(TForm)
    ListBox1: TListBox;
    Panel2: TPanel;
    LCaption: TLabel;
    Image1: TImage;
    Panel1: TPanel;
    GroupBox1: TGroupBox;
    Panel3: TPanel;
    bOk: TButton;
    bCancel: TButton;
    bAdd: TButton;
    bDelete: TButton;
    Label1: TLabel;
    Label2: TLabel;
    eDisabledKey: TEdit;
    Label3: TLabel;
    lActualKey: TLabel;
    Button1: TButton;
    procedure bDeleteClick(Sender: TObject);
    procedure bAddClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure bOkClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    Keys : TStringlist;
  public
    procedure OnNewKey(VK, MF: integer);
  end;

function DisableKeyDlg(Keys: TStringlist): boolean;
function GetDisableKeyDlg: TDlgDisableKeys;

implementation

{$R *.dfm}

var
  DKeyDlg: TDlgDisableKeys = nil;

function GetDisableKeyDlg: TDlgDisableKeys;
begin
  result := DKeyDlg;
end;

function DisableKeyDlg(Keys: TStringlist): boolean;
var
  D: TDlgDisableKeys;
begin
   Application.CreateForm(TDlgDisableKeys,D);
   try
     D.Keys := Keys;
     result := D.ShowModal = idOk;
   finally
     D.Free;
   end;
end;


procedure TDlgDisableKeys.bAddClick(Sender: TObject);
var
 Key : string;
 KeyStr: string;
 VK, MF : integer;
 W : string;
begin
  Key := trim(eDisabledKey.Text);
  if Key <> '' then
  begin
    wlStrToVk(Key,w,VK,MF);
    wlVkToStr('',VK,MF,KeyStr);
    Key := trim(KeyStr);
    if Key <> '' then
      ListBox1.Items.Add(KeyStr)
    else
      ShowMessage('unkown key string');
  end;
end;

procedure TDlgDisableKeys.bDeleteClick(Sender: TObject);
var
  Index : integer;
begin
  Index :=  ListBox1.ItemIndex;
  if Index >= 0 then
  begin
    eDisabledKey.Text := ListBox1.Items[Index];
    ListBox1.Items.Delete(Index);
  end
  else
    ShowMessage('first select item');
end;

procedure TDlgDisableKeys.bOkClick(Sender: TObject);
var
  i: Integer;
  VK,MF : integer;
  W : string;
begin
  if Keys <> nil then
  begin
    for i := 0 to Keys.Count - 1 do
    begin
       wlStrToVk(Keys[i],w,VK,MF);
       wlDisableKey(0,VK,MF,0) // enable keys
    end;
    Keys.Assign(ListBox1.Items);
    for i := 0 to Keys.Count - 1 do
    begin
       wlStrToVk(Keys[i],w,VK,MF);
       wlDisableKey(0,VK,MF,1) // disable keys
    end;
  end;
  Close;
  ModalResult := mrOk;
end;

procedure TDlgDisableKeys.FormHide(Sender: TObject);
begin
  DKeyDlg := nil;
end;

procedure TDlgDisableKeys.FormShow(Sender: TObject);
begin
  if Keys <> nil then
    ListBox1.Items.Assign(Keys);
  eDisabledKey.SetFocus;
  DKeyDlg := self;
end;

procedure TDlgDisableKeys.OnNewKey(VK, MF: integer);
var
  KeyStr: string;
begin
  if vk <> VK_LBUTTON then
  begin
    wlVkToStr('',VK,MF,KeyStr);
    lActualKey.caption := KeyStr;
  end;
end;

procedure TDlgDisableKeys.Button1Click(Sender: TObject);
begin
   eDisabledKey.Text := lActualKey.Caption;
end;

end.
