unit Startmenu;

interface

uses
  Windows, Messages,StdCtrls, Controls, ComCtrls, Graphics, ExtCtrls, Menus, ImgList,
  jpeg, Classes, Forms, sysutils, Dialogs,ShellApi,dwlcore;

type
  TDwlStartmenu = class(TForm)
    ImageList1: TImageList;
    Image1: TImage;
    ListView1: TListView;
    Label1: TLabel;
    Image2: TImage;
    Label2: TLabel;
    Image3: TImage;
    procedure ListView1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure ListView1Click(Sender: TObject);
    procedure Image2Click(Sender: TObject);
    procedure ListView1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ListView1CustomDrawItem(Sender: TCustomListView; Item: TListItem;
      State: TCustomDrawState; var DefaultDraw: Boolean);
  protected
  private
    procedure SetFirstItem(L: TListView);
  public
  end;

function CreateStartmenu: HWnd;

var
  DwlStartmenu : TDwlStartmenu = nil;

implementation

{$R *.dfm}


function CreateStartmenu: HWnd;
begin
  if assigned(DwlStartmenu) then
  begin
     result := DwlStartmenu.Handle;
     exit;
  end;
  DwlStartmenu := TDwlStartmenu.Create(nil);    // create a stand alone window
// ATTENTION: please insert the following line of codes
// in your start menu otherwise your form will shown without components.
//
// The problem is, if you create a form with property visible = false
// and you want to show form with windows method ShowWindow(handle,SW_SHOWNORMAL),
// the form will be shows without components.
// I did not know if this is a bug in Delphi,
// However, with following line it works
  DwlStartmenu.Left := -500;
  DwlStartmenu.Visible := true;
  DwlStartmenu.Visible := false;
  result := DwlStartmenu.Handle;
end;

procedure TDwlStartmenu.FormCreate(Sender: TObject);
begin
  ListView1.Items.Clear;
  if wlWinVersion >= vWinVista then
  begin
    AutoSize := false;
    Image1.Visible := false;
    ListView1.Top  := 5;
    ListView1.Left := 5;
    ListView1.Height := Height -10;
    Label1.Visible := false;
    Image3.Visible := true;
  end;
end;


procedure TDwlStartmenu.SetFirstItem(L : TListView);
begin
  if L.Items.Count > 0 then
  begin
    if L.Selected = nil then
       L.Items[0].Selected := true;
    L.SetFocus;
  end;
end;


procedure TDwlStartmenu.FormActivate(Sender: TObject);
begin
  SetForegroundWindow(Handle);
  ActiveControl := ListView1;
  SetFirstItem(ListView1)
end;

procedure TDwlStartmenu.FormShow(Sender: TObject);
begin
  SetFirstItem(ListView1)
end;

procedure TDwlStartmenu.Image2Click(Sender: TObject);
begin
  wlSendKeyDown(ord('W'),MOD_ALT or MOD_SHIFT or MOD_CONTROL);
  wlSendKeyUp(ord('W'),MOD_ALT or MOD_SHIFT or MOD_CONTROL);
  //Application.Terminate;
end;

procedure TDwlStartmenu.ListView1Click(Sender: TObject);
var
  Item : TListItem;
  FileName : string;
begin
  if ListView1.Selected <> nil then
  begin
     //Item := ListView1.Items[ListView1.ItemIndex];
     Item := ListView1.Selected;
     if Item.SubItems.Count > 0  then
     begin
       ShowWindow(Handle,SW_HIDE);
       FileName := trim(Item.SubItems[0]);
       ShellExecute(Handle,nil,pchar(FileName),'','',SW_SHOWNORMAL);

     end
     else
       ShowMessage('wrong item');
  end;
end;

procedure TDwlStartmenu.ListView1CustomDrawItem(Sender: TCustomListView;
  Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
var
  x,y    : integer;
  LV     : TListView;
  P1, P2 : TPoint;
begin
  LV := Sender as TListView;
  if Item.Selected then
  begin
    LV.Canvas.Brush.Color := rgb(220,220,255);
    LV.Canvas.Pen.Color   := clInactiveCaption;
  end
  else
  begin
    LV.Canvas.Brush.Color := clWhite;
    LV.Canvas.Pen.Color   := LV.Canvas.Brush.Color;
  end;

  P1.X := Item.DisplayRect(drBounds).Left;
  P1.Y := Item.DisplayRect(drBounds).Top;
  P2.X := Item.DisplayRect(drBounds).Right;
  P2.Y := Item.DisplayRect(drBounds).Bottom;

  LV.Canvas.RoundRect(P1.X,P1.Y, P2.X,P2.Y,4,4);

  P1.X := Item.DisplayRect(drIcon).Left;
  P1.Y := Item.DisplayRect(drIcon).Top;
  LV.SmallImages.Draw(LV.Canvas,P1.X,P1.Y, Item.ImageIndex,dsTransparent,itImage);

  x := Item.DisplayRect(drLabel).Left+4;
  y := Item.DisplayRect(drLabel).Top+10;
  LV.Canvas.TextOut(x,y,Item.Caption);

  DefaultDraw := false;
end;

procedure TDwlStartmenu.ListView1MouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
var
  Item: TListItem;
begin
  Item := ListView1.GetItemAt(x, y);
  if Item <> nil then
  begin
    if not Item.Selected then
    begin
      Item.Selected := true;
      Item.Focused  := true;
    end;
  end;
end;

procedure TDwlStartmenu.ListView1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then
    ListView1Click(self);
end;

end.
