unit WinForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, windows, dwlcore;



type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    panel1: System.Windows.Forms.Panel;
    label1: System.Windows.Forms.Label;
    bInstallGina: System.Windows.Forms.Button;
    textBox1: System.Windows.Forms.TextBox;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure bInstallGina_Click(sender: System.Object; e: System.EventArgs);
    procedure TWinForm_Load(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    Disable: integer;
    procedure AddInfo(Info: string);
    procedure DwlKeyDownEvent(Wnd: Hwnd; Down, VK, MF: integer);
    procedure InitdWinlock;
  public

    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.panel1 := System.Windows.Forms.Panel.Create;
  Self.label1 := System.Windows.Forms.Label.Create;
  Self.bInstallGina := System.Windows.Forms.Button.Create;
  Self.textBox1 := System.Windows.Forms.TextBox.Create;
  Self.panel1.SuspendLayout;
  Self.SuspendLayout;
  // 
  // panel1
  // 
  Self.panel1.Controls.Add(Self.label1);
  Self.panel1.Controls.Add(Self.bInstallGina);
  Self.panel1.Dock := System.Windows.Forms.DockStyle.Bottom;
  Self.panel1.Location := System.Drawing.Point.Create(0, 294);
  Self.panel1.Name := 'panel1';
  Self.panel1.Size := System.Drawing.Size.Create(416, 48);
  Self.panel1.TabIndex := 2;
  // 
  // label1
  // 
  Self.label1.Location := System.Drawing.Point.Create(120, 16);
  Self.label1.Name := 'label1';
  Self.label1.Size := System.Drawing.Size.Create(272, 23);
  Self.label1.TabIndex := 1;
  Self.label1.Text := 'needed to disable Ctrl+Alt+Del under Win NT, 2k, XP';
  // 
  // bInstallGina
  // 
  Self.bInstallGina.Location := System.Drawing.Point.Create(8, 13);
  Self.bInstallGina.Name := 'bInstallGina';
  Self.bInstallGina.Size := System.Drawing.Size.Create(96, 23);
  Self.bInstallGina.TabIndex := 0;
  Self.bInstallGina.Text := 'Install dwl';
  Include(Self.bInstallGina.Click, Self.bInstallGina_Click);
  // 
  // textBox1
  // 
  Self.textBox1.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.textBox1.Location := System.Drawing.Point.Create(0, 0);
  Self.textBox1.Multiline := True;
  Self.textBox1.Name := 'textBox1';
  Self.textBox1.ScrollBars := System.Windows.Forms.ScrollBars.Vertical;
  Self.textBox1.Size := System.Drawing.Size.Create(416, 294);
  Self.textBox1.TabIndex := 3;
  Self.textBox1.Text := '';
  Self.textBox1.WordWrap := False;
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(416, 342);
  Self.Controls.Add(Self.textBox1);
  Self.Controls.Add(Self.panel1);
  Self.Name := 'TWinForm';
  Self.Text := 'WinForm3';
  Include(Self.Load, Self.TWinForm_Load);
  Self.panel1.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;


procedure TWinForm.bInstallGina_Click(sender: System.Object; e: System.EventArgs);
begin
  if wlIsDwlInstalled = 0 then
  begin
    if wlInstallDwl(0) = 1 then
      bInstallGina.Text := 'Uinstall dwl'
  end
  else
    if wlUnInstallDwl(0) = 1 then
      bInstallGina.Text := 'Install dwl'
end;

procedure DisableKey(Wnd: HWND; Key: Keys; Modifiers, disable: integer);
begin
   wlDisableKey(Wnd,integer(Key),Modifiers,disable);
end;

procedure DisableKeys(disable : integer);
var
 TBar: HWND;
begin
  wlDisableItem(wlTaskTray,disable);          // disables system trays

  DisableKey(0,Keys.Tab, MOD_ALT,disable);  // disable Alt+Tab
  DisableKey(0,Keys.Escape, MOD_CONTROL,disable);  // disable Ctrl+Esc
  DisableKey(0,Keys.F1,MOD_ALL,disable);   // MOD_ALL = also with Ctrl,Alt,Shift,Win Keys
  DisableKey(0,Keys.F11,0,disable);       // disable F11
  wlDisableKey(0,0,MOD_WIN,disable);        // disables all WIN keys
  if wlIsDwlInstalled = 1 then          // only if dwlgina is installed
    DisableKey(0,Keys.Delete,MOD_CONTROL or MOD_ALT,disable);

  // disables right mouse button only on taskbar window
  // MOD_ALL = disables Key also with Ctrl, Alt, Shift and Win Keys
  TBar := FindWindow('Shell_TrayWnd',nil);
  DisableKey(TBar,Keys.RButton,MOD_ALL,disable);
end;

procedure TWinForm.AddInfo(Info : string);
begin
  textBox1.AppendText(Info+Environment.NewLine);
end;


procedure TWinForm.InitdWinlock;
begin
  AddInfo('dWinlock core example');
  AddInfo('(c) 2003 Kassl GmbH (http://www.kassl.de)');
 // AddInfo(format('dwlgina version: %d.%d',[HIWORD(wlVersion),LOWORD(wlVersion)]));
  AddInfo('');
  AddInfo('Following keys are system wide disabled:');
  AddInfo('Alt+Tab');
  AddInfo('Ctrl+Esc');
  AddInfo('Win keys');
  AddInfo('F1 with all modifiers (Ctrl,Alt,Shift,Win)');
  AddInfo('F11 without modifiers');
  AddInfo('Right mouse button on task bar');
  AddInfo('and also Ctrl+Alt+Del if dwl is installed');
  AddInfo('');
  AddInfo('Press Shift+Ctrl+T to toggle (enable/disable)');
  AddInfo('');
  Disable := 1;
  wlSetObjKeyCallback(dwlKeydownEvent,kDownEvents); // we want key down events but not key up events
  DisableKeys(Disable);                           // disable keys
  Label1.Visible := false;
  bInstallGina.Enabled   := wlIsNtSystem = 1;
  if wlIsDwlInstalled = 0 then
  begin
    bInstallGina.Text := 'Install dwl';
    Label1.Visible := true;
  end
  else
    bInstallGina.Text := 'Uninstall dwl';
end;


procedure TWinForm.DwlKeyDownEvent(Wnd: Hwnd; Down, VK, MF: integer);
begin
  if wlIsKeyDisabled(0,VK,MF) = 1 then
    AddInfo('Sorry, but this key is disabled');

  // detect key Ctrl+Alt+Win+Shift+A (only an example)
  if (VK = Ord('A')) and (MF = MOD_WIN or MOD_CONTROL or MOD_ALT or MOD_SHIFT) then
    AddInfo('"hand break" key pressed :-)');

  // Ctrl+Shift+T to enable and disable keys
  if (VK = Ord('T')) and (MF = MOD_CONTROL or MOD_SHIFT) then
  begin
    if Disable = 1 then
    begin
      Disable := 0;
      AddInfo('Keys enabled');
    end
    else
    begin
      Disable := 1;
      AddInfo('Keys disabled');
    end;
    DisableKeys(Disable);
  end;

  // if Alt+Shift+W is pressed show window name
  if (VK = Ord('W')) and (MF = MOD_CONTROL or MOD_ALT) then
    AddInfo('Ctrl+Shift+W pressed in window: '+ dwlcore.GetClassName(Wnd));
end;

procedure TWinForm.TWinForm_Load(sender: System.Object; e: System.EventArgs);
begin
  InitdWinlock;
end;



end.
