VERSION 5.00
Begin VB.Form FormLock 
   Caption         =   "dWinlock core example"
   ClientHeight    =   1875
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   2580
   LinkTopic       =   "Form1"
   ScaleHeight     =   1875
   ScaleWidth      =   2580
   StartUpPosition =   3  'Windows-Standard
   Begin VB.CommandButton bUnlockWindows 
      Caption         =   "Unlock Windows"
      Height          =   495
      Left            =   240
      TabIndex        =   1
      Top             =   840
      Width           =   1935
   End
   Begin VB.CommandButton bLockWindows 
      Caption         =   "Lock Windows"
      Height          =   495
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   1935
   End
End
Attribute VB_Name = "FormLock"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' virtual key codes
' For more info see win32api.txt file supplied with Visual Basic
Const VK_ESCAPE = &H1B
Const VK_F4 = &H73
Const VK_DELETE = &H2E


Private Sub LockWindows(disable As Long)
  Dim ret As Long
  Dim hTaskBar As Long
  Dim hStartButton As Long
  Dim hProgman As Long
  
  ret = wlDisableItem(wlTaskTray, disable)
  ret = wlDisableItem(wlDesktop, disable)
  ret = wlDisableItem(wlTaskLinks, disable)
  ret = wlDisableItem(wlStartbutton, disable)

  ' find handles for task bar and start button
  hTaskBar = FindWindowEx(0, 0, "Shell_TrayWnd", "")
  hStartButton = FindWindowEx(hTaskBar, 0, "Button", "")
  hProgman = FindWindowEx(0, 0, "Progman", "")
  
  ' disables all WIN keys
  ret = wlDisableKey(0, 0, MOD_WIN, disable)
  ret = wlDisableKey(0, VK_ESCAPE, MOD_CONTROL, disable)
  ret = wlDisableKey(0, VK_F4, MOD_ALT, disable)
  ' ret = wlDisableKey(0,VK_TAB, MOD_ALT,disable)
  ' ret = wlDisableKey(0,VK_ESCAPE, MOD_ALT,disable)

  ' disables all keys for program manager (desktop)
  If hProgman > 0 Then
    ret = wlDisableKey(hProgman, 0, MOD_ALL, disable)
  End If

  ' disables all keys (mouse buttons included) for task bar
  If hTaskBar > 0 Then
    ret = wlDisableKey(hTaskBar, 0, MOD_ALL, disable)
  End If
  
  ' only if dwlgina is installed
  'If wlIsGinaInstalled Then
    ' disables Ctrl+Alt+Del
    ret = wlDisableKey(0, VK_DELETE, MOD_CONTROL Or MOD_ALT, disable)
End Sub

Private Sub bLockWindows_Click()
  LockWindows (1)
End Sub

Private Sub bUnlockWindows_Click()
  ' LockWindows (0) also possible
  wlRestoreAll
End Sub


Private Sub Form_Unload(Cancel As Integer)
  ' required, because VB IDE does'nt unload dwlgina
  wlRestoreAll
End Sub
