@echo off

@set HOME="%CD%"
@set BUILD=%2
@set EFI_BOOT_DISK=%1
@set DISK_LABEL=UEFI_DUET
@set PROCESSOR=X64 INTEL ICH10 (X58)
@set FILESYSTEM=FAT32
@set WIN_BIN_DIR=%HOME%\DUET\Binaries
@set BOOTSECTOR_BIN_DIR=%HOME%\DUET\BootSector
@set EFILDR_DIR=%HOME%\DUET\Efildr\
@set BOOT_DIR=%HOME%\DUET\EFI\Boot
@set TOOLS_DIR=%HOME%\DUET\EFI\Tools
@set NVME_DIR=%HOME%\DUET\EFI\Drivers
@set REFIND_DIR=%HOME%\Refind
@set FORMAT="NOTSET"
@set MBRSET="NOTSET"
@set DISKPART="NOTSET"
@set REMOVABLE="NOTSET"
@if "%1"=="" goto Help
@goto Permissions

:Details 
@echo ------------------------------------------------------------------------------
@echo         Tianocore-UEFI-DUET FIRMWARE ARCH = %PROCESSOR%
@echo         Tianocore-UEFI-DUET COMMAND = %2
@echo         Removable DISK DRIVE = %1
@echo         Removable DISK DRIVE FILESYSTEM = %FILESYSTEM%
@echo ------------------------------------------------------------------------------
if "%2"=="CLEAN" (
		goto DISKPART_step1
    ) else if "%2"=="FORMAT" (
		goto FORMAT_step1
   ) else if "%2"=="BOOT" (
		goto BOOT_step1
   ) else if "%2"=="DUET" (
		goto DUET_step1
   ) else if "%2"=="REFIND" (
		goto REFIND_step1
   ) else (
        goto Help
   )	
 ))
goto :EOF

:FORMAT_step1
@cls
@echo ------------------------------------------------------------------------------
@echo(
@echo         WARNING!! BE SURE THE RIGHT VOLUME IS SELECTED.
@echo(
@echo         SELECTED DRIVE IS = %EFI_BOOT_DISK%
@echo(
@echo         ARE YOU SURE TO CONTINUE?
@echo(
@echo         The next command will FORMAT the selected DISK!
@echo(
@echo         Setting Format parameter... 
@echo(
@echo         TXT COMMAND is avaiable in FormatCommandInput.txt (DO NOT MODIFY)
@echo ------------------------------------------------------------------------------
@for /f "tokens=2 delims==" %%d in ('wmic logicaldisk where "drivetype=2" get name /format:value') do set "REMOVABLE=%%d"
if %REMOVABLE% == %EFI_BOOT_DISK% (
@echo(
@echo         Formatting %EFI_BOOT_DISK% as FAT32...
@echo(		
    ) else (
@echo(	
@echo         WARNING !! The selected device is NOT removable !!
@echo				                   Or
@echo         WARNING !! Multiple instance of removable devices found !!
@echo(		
		goto :EOF
    )
if EXIST %HOME%\FormatCommandInput.txt ( del %HOME%\FormatCommandInput.txt )	
@echo /FS:%FILESYSTEM% /v:%DISK_LABEL% /q %EFI_BOOT_DISK% > FormatCommandInput.txt
@set /P "FORMAT=Type AGREE (in CAPS) and press ENTER to proceed: "
if "%FORMAT%"=="CreateUSB.bat %EFI_BOOT_DISK% FORMAT"  (
    exit /B
    ) else if "%FORMAT%"=="CreateUSB %EFI_BOOT_DISK% FORMAT" (
	exit /B
    ) else if "%FORMAT%"=="AGREE" (
		goto FORMAT_step2
    ) else (
        goto :EOF
    )
))
@echo ------------------------------------------------------------------------------
goto end
	
:FORMAT_step2
@echo ------------------------------------------------------------------------------
@echo         Launching Format...
@echo ------------------------------------------------------------------------------
@format /FS:%FILESYSTEM% /v:%DISK_LABEL% /q %EFI_BOOT_DISK% < FormatCommandInput.txt > NUL
if EXIST %HOME%\FormatCommandInput.txt ( del %HOME%\FormatCommandInput.txt )
@echo ------------------------------------------------------------------------------
@echo         %EFI_BOOT_DISK% COMMAND %BUILD% Complete.
@echo ------------------------------------------------------------------------------
@goto end

:BOOT_step1
@echo         Setting up FAT32 boot sector...
@echo ------------------------------------------------------------------------------
@copy %BOOTSECTOR_BIN_DIR%\bs32.com %HOME%\bs32.com1
@%WIN_BIN_DIR%\Genbootsector.exe --verbose -i %EFI_BOOT_DISK% -o %HOME%\Usbbs32.com
@%WIN_BIN_DIR%\Bootsectimage.exe --verbose -g %HOME%\Usbbs32.com %HOME%\bs32.com1 -f
if EXIST %HOME%\Usbbs32.com ( del %HOME%\Usbbs32.com )
@%WIN_BIN_DIR%\Genbootsector.exe --verbose -o %EFI_BOOT_DISK% -i %HOME%\bs32.com1 
@%WIN_BIN_DIR%\Genbootsector.exe --verbose --mbr -o %EFI_BOOT_DISK% -i %BOOTSECTOR_BIN_DIR%\Mbr.com 
if EXIST %HOME%\bs32.com1 ( del %HOME%\bs32.com1 )
@echo ------------------------------------------------------------------------------
@echo         %EFI_BOOT_DISK% COMMAND %BUILD% Done.
@echo         UNPLUG THE REMOVABLE DISK, THEN PLUG IT AGAIN ( DO IT )
@echo ------------------------------------------------------------------------------
@set MBRSET=BOOTABLE
@echo %2 %MBRSET% > %HOME%\ConfigBoot.txt
@goto end

:DUET_step1
@echo         Creating Tianocore UEFI DUET removable DATA disk...
@echo ------------------------------------------------------------------------------
@copy %EFILDR_DIR%\EfiLdr20 %EFI_BOOT_DISK%\Efildr20 /y
@mkdir %EFI_BOOT_DISK%\EFI
@mkdir %EFI_BOOT_DISK%\EFI\Boot
@copy %TOOLS_DIR%\shellx64.efi %EFI_BOOT_DISK%\EFI\Boot\Bootx64.efi /y
@copy %TOOLS_DIR%\startup.nsh %EFI_BOOT_DISK%\EFI\Boot\startup.nsh /y
@echo ------------------------------------------------------------------------------
@echo         %EFI_BOOT_DISK% COPY %BUILD% Complete.
@goto end

:REFIND_step1
@echo         Creating Tianocore UEFI REFIND removable DATA disk...
@echo ------------------------------------------------------------------------------
@mkdir %EFI_BOOT_DISK%\EFI\Tools
@mkdir %EFI_BOOT_DISK%\EFI\Boot\drivers
@mkdir %EFI_BOOT_DISK%\EFI\Boot\fonts
@mkdir %EFI_BOOT_DISK%\EFI\Boot\icons
@mkdir %EFI_BOOT_DISK%\EFI\Boot\themes\Min\icons
@copy %TOOLS_DIR%\shellx64.efi %EFI_BOOT_DISK%\EFI\Tools\shellx64.efi /y
@copy %REFIND_DIR%\refind.efi %EFI_BOOT_DISK%\EFI\Boot\Bootx64.efi /y
@copy %REFIND_DIR%\refind.conf %EFI_BOOT_DISK%\EFI\Boot\refind.conf /y
@copy %REFIND_DIR%\drivers\*Dxe.efi %EFI_BOOT_DISK%\EFI\Boot\drivers\*Dxe.efi /y
@copy %REFIND_DIR%\fonts\*.png %EFI_BOOT_DISK%\EFI\Boot\fonts\*.png /y
@copy %REFIND_DIR%\icons\*.png %EFI_BOOT_DISK%\EFI\Boot\icons\*.png /y
@copy %REFIND_DIR%\themes\Min\*.png %EFI_BOOT_DISK%\EFI\Boot\themes\Min\*.png /y
@copy %REFIND_DIR%\themes\Min\icons\*.png %EFI_BOOT_DISK%\EFI\Boot\themes\Min\icons\*.png /y
if NOT EXIST %HOME%\ConfigBoot.txt ( goto REFIND_step2 ) 
if EXIST %HOME%\ConfigBoot.txt ( del %HOME%\ConfigBoot.txt )
@echo ------------------------------------------------------------------------------
@echo         %EFI_BOOT_DISK% COPY %BUILD% Complete.
@goto end

:REFIND_step2
@echo          Setting up NVME driver...
@echo ------------------------------------------------------------------------------
@mkdir %EFI_BOOT_DISK%\EFI\Boot\drivers
@copy %NVME_DIR%\NvmExpressDxe.efi %EFI_BOOT_DISK%\EFI\Boot\drivers\NvmExpressDxe.efi /y
if EXIST %HOME%\ConfigBoot.txt ( del %HOME%\ConfigBoot.txt )
@echo ------------------------------------------------------------------------------
@echo         %EFI_BOOT_DISK% COMMAND %BUILD% Complete.
@goto end

:Permissions
    net session >nul 2>&1
    if %errorLevel% == 0 (
		@goto Details
    ) else (
        echo This script must be run as administrator.
    )
    goto End

:Help
@cls
@echo ------------------------------------------------------------------------------
@echo         The possible ARGUMENTS are: CLEAN ^| FORMAT ^| BOOT ^| DUET ^| REFIND 
@echo(
@echo         CLEAN will call DISKPART and wipe the selected removable DISK.
@echo         FORMAT will FORMAT and label the removable DISK.
@echo         BOOT will make the removable DISK bootable.
@echo         DUET will copy DUET and the required file on the removable DISK.
@echo         REFIND will copy REFIND and the required file on the removable DISK.
@echo(
@echo         Usage : CreateUSB Drive_Letter: ARGUMENTS
@echo(
@echo         OPTIONAL : CreateUSB K: CLEAN ( see WARNINGS )
@echo(
@echo         STEP 1 : CreateUSB K: FORMAT
@echo         STEP 2 : CreateUSB K: BOOT
@echo         UNPLUG USB, THEN PLUG IT AGAIN ( DO IT )
@echo         STEP 3 : CreateUSB K: DUET
@echo(
@echo         OPTIONAL STEP 4: CreateUSB K: REFIND ( see README ) BOOT MANAGER
@echo(
@echo ------------------------------------------------------------------------------
goto end

:DISKPART_step0
@echo ------------------------------------------------------------------------------
@echo         The CLEAN command without user input is currently disabled.
@echo ------------------------------------------------------------------------------
goto :EOF

:DISKPART_step1
@cls
@echo ------------------------------------------------------------------------------
@echo(
@echo         WARNING!! BE SURE THE RIGHT VOLUME IS SELECTED.
@echo(
@echo         SELECTED DRIVE IS = %EFI_BOOT_DISK%
@echo(
@echo         ARE YOU SURE TO CONTINUE?
@echo(
@echo         The next command will CLEAN the selected DISK!
@echo(
@echo         Setting Diskpart parameter... 
@echo(
@echo         TXT COMMAND is avaiable in CleanCommandInput.txt (DO NOT MODIFY)
@echo ------------------------------------------------------------------------------
@for /f "tokens=2 delims==" %%d in ('wmic logicaldisk where "drivetype=2" get name /format:value') do set "REMOVABLE=%%d"
if %REMOVABLE% == %EFI_BOOT_DISK% (
@echo(
@echo         Removable DISK selected %REMOVABLE% 
@echo(		
    ) else (
@echo(	
@echo         WARNING !! The selected device is NOT removable !!
@echo				                   Or
@echo         WARNING !! Multiple instance of removable device found !!
@echo(		
		goto :EOF
    )
if EXIST %HOME%\CleanCommandInput.txt ( del %HOME%\CleanCommandInput.txt )	
@echo sel vol %EFI_BOOT_DISK% > CleanCommandInput.txt
@echo clean >> CleanCommandInput.txt
@echo convert mbr >> CleanCommandInput.txt
@echo create partition primary offset=1024 >> CleanCommandInput.txt
@echo format fs=fat32 quick >> CleanCommandInput.txt
@echo exit >> CleanCommandInput.txt
@set /P "DISKPART=Type AGREE (in CAPS) and press ENTER to proceed: "
if "%DISKPART%"=="CreateUSB.bat %EFI_BOOT_DISK% CLEAN"  (
    exit /B
    ) else if "%DISKPART%"=="CreateUSB %EFI_BOOT_DISK% CLEAN" (
	exit /B
    ) else if "%DISKPART%"=="AGREE" (
		goto DISKPART_step2
    ) else (
        goto :EOF
    )
))
@echo ------------------------------------------------------------------------------
goto end

:Diskpart_step2
@echo ------------------------------------------------------------------------------
@echo         Launching Diskpart...
@echo ------------------------------------------------------------------------------
if EXIST %HOME%\CleanCommandInput.txt ( @diskpart /s %HOME%\CleanCommandInput.txt )
if EXIST %HOME%\CleanCommandInput.txt ( del %HOME%\CleanCommandInput.txt )
@echo ------------------------------------------------------------------------------
goto end


:End
@echo off
@exit /B
pause