CONTAINER Tcawcycle
{
	NAME Tcawcycle;
	INCLUDE Obase;
	
	GROUP Obaselist
	{
		PRIORITY ID_CA_WCYCLE_TAG_EXPRESSION_PRIORITY { ANIM OFF; }
			
		GROUP ID_CA_WCYCLE_TAG_GROUP_ANIMATE
		{			
			COLUMNS 2; DEFAULT 1;
				
			BOOL ID_CA_WCYCLE_TAG_AUTOTIME { ANIM OFF; SCALE_H; }
			STATICTEXT { DUMMY; SCALE_H; }

			BASETIME ID_CA_WCYCLE_TAG_START { ANIM OFF; SCALE_H; }
			BASETIME ID_CA_WCYCLE_TAG_STOP  { ANIM OFF; SCALE_H; }
		}

		GROUP
		{
			COLUMNS 2;
					
			BUTTON ID_CA_WCYCLE_TAG_LOAD_PRESET { }
			BUTTON ID_CA_WCYCLE_TAG_SAVE_PRESET { }
		}
	}
	
	GROUP ID_OBJECTPROPERTIES
	{
		COLUMNS 1;
		
		GROUP
		{
			COLUMNS 2;
			
			LONG ID_CA_WCYCLE_TAG_WALK_TYPE
			{
				ANIM OFF;
				SCALE_H;
				CYCLE
				{
					ID_CA_WCYCLE_TAG_WALK_TYPE_STATIC;
					ID_CA_WCYCLE_TAG_WALK_TYPE_LINE;
					ID_CA_WCYCLE_TAG_WALK_TYPE_PATH;
				}
			}
			
			LONG ID_CA_WCYCLE_TAG_WALK_MODE
			{
				ANIM OFF;
			
				SCALE_H;
				CYCLE
				{
					ID_CA_WCYCLE_TAG_WALK_MODE_INTERPOLATED;
					ID_CA_WCYCLE_TAG_WALK_MODE_ADAPTIVE;
				}
			}
			
			REAL ID_CA_WCYCLE_TAG_STRIDE { UNIT METER; SCALE_H; MINSLIDER 0.0; MAXSLIDER 1000.0; CUSTOMGUI REALSLIDER; }
			BASETIME ID_CA_WCYCLE_TAG_STRIDE_TIME  { SCALE_H; }
			
			REAL ID_CA_WCYCLE_TAG_DIRECTION { ANIM OFF; UNIT DEGREE; SCALE_H; MINSLIDER -180.0; MAXSLIDER 180.0; CUSTOMGUI REALSLIDER; }
			REAL ID_CA_WCYCLE_TAG_GRADIENT { ANIM OFF; UNIT DEGREE; SCALE_H; MIN -180.0; MAX 180.0; CUSTOMGUI REALSLIDER; }
			
			LINK ID_CA_WCYCLE_TAG_PATH { ACCEPT { Obase; } }
			STATICTEXT { JOINENDSCALE; }			
		}

		GROUP ID_CA_WCYCLE_TAG_GROUP_OBJECTS
		{
			DEFAULT 1;
			
			GROUP
			{
				COLUMNS 2;
				
				LONG ID_CA_WCYCLE_TAG_ACTIONS { CYCLE {} SCALE_H; ANIM OFF; }				
				BUTTON ID_CA_WCYCLE_TAG_ACTION_ADD { SCALE_H; }
			}
			
			GROUP
			{
				ITEMTREE ID_CA_WCYCLE_TAG_OBJECTS
				{
					DRAGDROP;
					COLUMNS 2;
					ROWS 12;
					MAXROWS 25;
					HEADERS;
					ICON;
					MULTIPLE;
					ACCEPT { Obase; }
				}
			}
		}
		
		GROUP ID_CA_WCYCLE_TAG_GROUP_MOTION
		{	
			HIDDEN; DEFAULT 1;
		
			GROUP
			{
				COLUMNS 2;
				
				LONG ID_CA_WCYCLE_TAG_TARGET_PLACEMENT
				{
					SCALE_H;
					CYCLE
					{
						ID_CA_WCYCLE_TAG_TARGET_PLACEMENT_DEFAULT;
						ID_CA_WCYCLE_TAG_TARGET_PLACEMENT_LINE;
						ID_CA_WCYCLE_TAG_TARGET_PLACEMENT_SPACED;
					}
				}
				REAL ID_CA_WCYCLE_TAG_TARGET_PLACEMENT_SPACE { SCALE_H; UNIT METER; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
			}
		}
			
		GROUP ID_CA_WCYCLE_TAG_PARAMS_GROUP
		{
			COLUMNS 2; DEFAULT 1;
		}		
	}
	
	GROUP ID_CA_WCYCLE_TAG_GROUP_POSE
	{
		COLUMNS 1;

		GROUP
		{
			COLUMNS 2;
			
			BOOL ID_CA_WCYCLE_TAG_FOLLOW { ANIM OFF; }
			REAL ID_CA_WCYCLE_TAG_HUB_TARGETTING { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; SCALE_H; }
			
			BOOL ID_CA_WCYCLE_TAG_BANK { ANIM OFF; }
			
			LONG ID_CA_WCYCLE_TAG_HUB_RETARGET
			{
				SCALE_H;
			
				CYCLE
				{
					ID_CA_WCYCLE_TAG_HUB_RETARGET_NONE;
					ID_CA_WCYCLE_TAG_HUB_RETARGET_VERT;
					ID_CA_WCYCLE_TAG_HUB_RETARGET_CENTER;
					ID_CA_WCYCLE_TAG_HUB_RETARGET_WEIGHTED;
				}
			}	
		}
		
		GROUP ID_CA_WCYCLE_TAG_GROUP_ROOT
		{
			DEFAULT 1;
		
			GROUP
			{
				COLUMNS 2;
				
				LONG ID_CA_WCYCLE_TAG_HUB_ROOT_TYPE
				{				
					CYCLE
					{
						ID_CA_WCYCLE_TAG_HUB_ROOT_TYPE_MAIN;
						ID_CA_WCYCLE_TAG_HUB_ROOT_TYPE_WORLD;
						ID_CA_WCYCLE_TAG_HUB_ROOT_TYPE_OBJECT;
					}
				}
				LINK ID_CA_WCYCLE_TAG_HUB_ROOT { ACCEPT { Obase; } }
				
				BOOL ID_CA_WCYCLE_TAG_HUB_ROOT_AUTO { }
				STATICTEXT { DUMMY; }
				
				REAL ID_CA_WCYCLE_TAG_HUB_ROOT_OFFSET { UNIT METER; MINSLIDER -100.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
				STATICTEXT { JOINENDSCALE; }
			}
			
			GROUP ID_CA_WCYCLE_TAG_GROUP_AXES
			{
				COLUMNS 2;	DEFAULT 1;
				
				LONG ID_CA_WCYCLE_TAG_WALK_AXIS
				{
					CYCLE
					{
						ID_CA_WCYCLE_TAG_AXIS_X;
						ID_CA_WCYCLE_TAG_AXIS_Y;
						ID_CA_WCYCLE_TAG_AXIS_Z;
						ID_CA_WCYCLE_TAG_AXIS_NX;
						ID_CA_WCYCLE_TAG_AXIS_NY;
						ID_CA_WCYCLE_TAG_AXIS_NZ;
					}
				}
						
				LONG ID_CA_WCYCLE_TAG_VERT_AXIS
				{
					CYCLE
					{
						ID_CA_WCYCLE_TAG_AXIS_X;
						ID_CA_WCYCLE_TAG_AXIS_Y;
						ID_CA_WCYCLE_TAG_AXIS_Z;
						ID_CA_WCYCLE_TAG_AXIS_NX;
						ID_CA_WCYCLE_TAG_AXIS_NY;
						ID_CA_WCYCLE_TAG_AXIS_NZ;
					}
				}
			}
		}
		
		GROUP ID_CA_WCYCLE_TAG_GROUP_RESTPOSE
		{
			COLUMNS 2; HIDDEN;
			
			BUTTON ID_CA_WCYCLE_STORE_RESTPOSE { }
			BUTTON ID_CA_WCYCLE_RESTORE_RESTPOSE { }
		}
	}
	
	GROUP ID_CA_WCYCLE_TAG_GROUP_ROUTE
	{
		BOOL ID_CA_WCYCLE_TAG_PREVIEW { }
		
		GROUP ID_CA_WCYCLE_TAG_GROUP_PATH
		{
			COLUMNS 2; DEFAULT 1;
						
			REAL ID_CA_WCYCLE_TAG_PATH_START { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; SCALE_H; }
			REAL ID_CA_WCYCLE_TAG_PATH_END { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; SCALE_H; }
	
			BOOL ID_CA_WCYCLE_TAG_AXIS_ALIGN_HUB { SCALE_H; }
			LONG ID_CA_WCYCLE_TAG_ALIGN_AXIS
			{
				SCALE_H;
				
				CYCLE
				{
					ID_CA_WCYCLE_TAG_AXIS_X;
					ID_CA_WCYCLE_TAG_AXIS_Y;
					ID_CA_WCYCLE_TAG_AXIS_Z;
					ID_CA_WCYCLE_TAG_AXIS_NX;
					ID_CA_WCYCLE_TAG_AXIS_NY;
					ID_CA_WCYCLE_TAG_AXIS_NZ;
				}
			}
				
			BOOL ID_CA_WCYCLE_TAG_PATH_PROJECTION { SCALE_H; }
			STATICTEXT { NEWLINE; }			
		}
		
		GROUP ID_CA_WCYCLE_TAG_GROUP_SURFACE
		{
			COLUMNS 2; DEFAULT 1;
			
			LINK ID_CA_WCYCLE_TAG_SURFACE { ACCEPT { Obase; } }		
			REAL ID_CA_WCYCLE_TAG_SURFACE_OFFSET { UNIT METER; SCALE_H; MINSLIDER -100.0; MAXSLIDER 100.0; }
			
			LONG ID_CA_WCYCLE_TAG_SURFACE_PROJECTION
			{
				SCALE_H;
			
				CYCLE
				{
					ID_CA_WCYCLE_TAG_SURFACE_PROJECTION_CLOSEST;
					ID_CA_WCYCLE_TAG_SURFACE_PROJECTION_DOWN;
					ID_CA_WCYCLE_TAG_SURFACE_PROJECTION_TOPATH;
				}
			}			
			LONG ID_CA_WCYCLE_TAG_SURFACE_BASE
			{
				SCALE_H;
				
				CYCLE
				{
					ID_CA_WCYCLE_TAG_SURFACE_BASE_POINT;
					ID_CA_WCYCLE_TAG_SURFACE_BASE_RECT;
					ID_CA_WCYCLE_TAG_SURFACE_BASE_OBJECT;
				}
			}
			
			REAL ID_CA_WCYCLE_TAG_SURFACE_BASE_WIDTH { UNIT METER; MIN 0.0; }
			REAL ID_CA_WCYCLE_TAG_SURFACE_BASE_LENGTH { UNIT METER; MIN 0.0; }
			
			BOOL ID_CA_WCYCLE_TAG_SURFACE_ALIGN_HUB { SCALE_H; }
			BOOL ID_CA_WCYCLE_TAG_SURFACE_ALIGN_TARGET { SCALE_H; }

			BOOL ID_CA_WCYCLE_TAG_LIMIT { SCALE_H; }
			REAL ID_CA_WCYCLE_TAG_LIMIT_DISTANCE { UNIT METER; MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }			
		}
	}
	
	GROUP ID_CA_WCYCLE_TAG_GROUP_FOOTSTEPS
	{
		COLUMNS 2;
		
		LONG ID_CA_WCYCLE_TAG_STEPS_TYPE
		{
			ANIM OFF;
			
			CYCLE
			{
				ID_CA_WCYCLE_TAG_STEPS_TYPE_STEPS;
				ID_CA_WCYCLE_TAG_STEPS_TYPE_HUBS;
				ID_CA_WCYCLE_TAG_STEPS_TYPE_FULL;
			}
		}
		
		LONG ID_CA_WCYCLE_STORE_AUTO_CREATESTEPS
		{
			ANIM OFF;
		
			CYCLE
			{
				ID_CA_WCYCLE_STORE_AUTO_CREATESTEPS_ALL;
				ID_CA_WCYCLE_STORE_AUTO_CREATESTEPS_CURRENT;
				ID_CA_WCYCLE_STORE_AUTO_CREATESTEPS_CUSTOM;
			}
		}
		
		LONG ID_CA_WCYCLE_STORE_CREATESTEPS_NUMBER { MIN 0; MAXSLIDER 1000; MAX 10000; CUSTOMGUI LONGSLIDER; ANIM OFF; }
		STATICTEXT { JOINENDSCALE; }
			
		BUTTON ID_CA_WCYCLE_STORE_CREATESTEPS { }
		STATICTEXT { JOINENDSCALE; }
		
		SEPARATOR { LINE; }
		STATICTEXT { JOINENDSCALE; }

		LINK ID_CA_WCYCLE_TAG_STEPS { ACCEPT { Obase; } }
		REAL ID_CA_WCYCLE_TAG_STEPS_WEIGHT { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
	}
	
	GROUP ID_CA_WCYCLE_TAG_GROUP_HUB_BASE
	{	
		HIDDEN;
									
		REAL ID_CA_WCYCLE_TAG_ACTION_WEIGHT { HIDDEN; }
		
		LINK ID_CA_WCYCLE_TAG_HUB { HIDDEN; ACCEPT { Obase; } }
		REAL ID_CA_WCYCLE_TAG_HUB_PHASE { HIDDEN; UNIT PERCENT; MIN -100.0; MAX 100.0; }
		BOOL ID_CA_WCYCLE_TAG_HUB_AUTOOFFSET { HIDDEN; }
		REAL ID_CA_WCYCLE_TAG_HUB_OFFSET { HIDDEN; UNIT METER; MINSLIDER -100.0; MAXSLIDER 100.0; }
		REAL ID_CA_WCYCLE_TAG_HUB_VOFFSET { HIDDEN; UNIT METER; MINSLIDER -100.0; MAXSLIDER 100.0; }
		REAL ID_CA_WCYCLE_TAG_HUB_HOFFSET { HIDDEN; UNIT METER; MINSLIDER -100.0; MAXSLIDER 100.0; }
		LONG ID_CA_WCYCLE_TAG_HUB_MOTIONS { HIDDEN; }
		
		LONG ID_CA_WCYCLE_TAG_ACTION_MIX
		{	
			SCALE_H; HIDDEN;
			
			CYCLE
			{
				ID_CA_WCYCLE_TAG_ACTION_MIX_ABS;
				ID_CA_WCYCLE_TAG_ACTION_MIX_ADD;
				ID_CA_WCYCLE_TAG_ACTION_MIX_SUB;
				ID_CA_WCYCLE_TAG_ACTION_MIX_MULT;
			}
		}
		
		REAL ID_CA_WCYCLE_TAG_ACTION_MIX_WEIGHT { HIDDEN; UNIT PERCENT; MIN 0.0; MAX 100.0; }
				
		GROUP ID_CA_WCYCLE_TAG_GROUP_TARGET
		{		
			COLUMNS 2; DEFAULT 1; HIDDEN;
			
			SEPARATOR { }
			STATICTEXT { JOINEND; }
			
			LONG ID_CA_WCYCLE_TAG_TARGET_WALK
			{
				HIDDEN;
				
				CYCLE
				{
					ID_CA_WCYCLE_TAG_TARGET_WALK_NONE;
					ID_CA_WCYCLE_TAG_TARGET_WALK_HUB;
					ID_CA_WCYCLE_TAG_TARGET_WALK_PATH;
					ID_CA_WCYCLE_TAG_TARGET_WALK_STEPS;
				}
			}
			
			LINK ID_CA_WCYCLE_TAG_TARGET { HIDDEN; ACCEPT { Obase; } }
			REAL ID_CA_WCYCLE_TAG_TARGET_PHASE { HIDDEN; UNIT PERCENT; MIN -100.0; MAX 100.0; }
			REAL ID_CA_WCYCLE_TAG_TARGET_OFFSET { HIDDEN; UNIT METER; MINSLIDER -100.0; MAXSLIDER 100.0; }
			REAL ID_CA_WCYCLE_TAG_TARGET_VOFFSET { HIDDEN; UNIT METER; MINSLIDER -100.0; MAXSLIDER 100.0; }
			REAL ID_CA_WCYCLE_TAG_TARGET_HOFFSET { HIDDEN; UNIT METER; MINSLIDER -100.0; MAXSLIDER 100.0; }
		}
	}
	
	GROUP ID_CA_WCYCLE_TAG_GROUP_ANALYSIS
	{
		HIDDEN;
		
		BOOL ID_CA_WCYCLE_TAG_ANALYSE { }
		
		BOOL ID_CA_WCYCLE_TAG_ANALYSIS_AUTO { }
		GROUP
		{
			COLUMNS 2;
			
			BASETIME ID_CA_WCYCLE_TAG_ANALYSIS_START { }
			BASETIME ID_CA_WCYCLE_TAG_ANALYSIS_END { }
		}
		
		GROUP
		{
			COLUMNS 2;
			
			BUTTON ID_CA_WCYCLE_TAG_ANALYSIS_CALC { }
			BUTTON ID_CA_WCYCLE_TAG_ANALYSIS_PATHTOSPLINE { }
		}
											
		REAL ID_CA_WCYCLE_TAG_ANALYSIS_FLOOR { UNIT METER; }
		REAL ID_CA_WCYCLE_TAG_ANALYSIS_STRIDE { UNIT METER; }
		BASETIME ID_CA_WCYCLE_TAG_ANALYSIS_TIME { }
		
		GROUP
		{
			COLUMNS 2;
			
			LINK ID_CA_WCYCLE_TAG_ANALYSIS_INPUT { ACCEPT { Obase; } } 
			LINK ID_CA_WCYCLE_TAG_ANALYSIS_OUPUT { ACCEPT { Obase; } } 
			BOOL ID_CA_WCYCLE_TAG_ANALYSIS_OUPUT_STATIC { }
		}
		
		LINK ID_CA_WCYCLE_TAG_ANALYSIS_MOTION { ACCEPT { Obase; } } 
		
		BUTTON ID_CA_WCYCLE_TAG_ANALYSIS_CREATEMO { }
	}
}
